let data;
let temps = [];

function preload() {
    data = loadJSON("PRSA-adapted-aparrish.json", loaded);//load the data with a callback function - this might be a time to push all of the data to an array, rather than in setup
    
}

function setup() {
    createCanvas(640,480);
    background(50);
    //what's going to give us the size of the array?
    //console.log(data);//this returns everything as an object
    //console.log(data.rows);//this returns everything in the rows property (an array of rows from the CSV)
    console.log(data.rows.length);//this returns 41,757 - the number of rows in the CSV version
    
    //so, where are the temps? data.rows[i].TEMP
    //push the values into the temps array with a for loop so we can get the min and max of this array of values
    for (var i=0;i<data.rows.length;i++){
        //get the TEMP at current index value
        var thisTemp = data.rows[i].TEMP;
        //push the value into the temps array
        temps.push(thisTemp);
        //just checking that we have that in the array
        //console.log(temps[i]);  //uncomment this line to watch the magic but it wll take a minute
    }//made the temps[] array
    
    //get min and max of that array
    let minTemp = min(temps);
    let maxTemp = max(temps);
    //check
    console.log("minTemp: " + minTemp);
    console.log("maxTemp: " + maxTemp);
    
    //now loop through the new temps array
    for(var i=0; i<temps.length; i++){
        //get the temp
        let val = temps[i];
        //map TEMP reading number (index val) to scale of width to number of readings (number of rows)
        let xpos = map(i,0,data.rows.length,0,width);
        //map TEMP reading value to height / scale of min and max vals
        let ypos = map(val,minTemp,maxTemp,height,0);
        //map the temp val to 0,255 to control the red val in stroke
        let colorTemp = map(val,-20,45,0,255);
        //make the graph!
        stroke(colorTemp,125,125);
        point(xpos,ypos);
        
    }
    //give a zero line
    stroke(255);
    let zeroVal = map(0,minTemp,maxTemp,height,0);
    line(0,zeroVal,width,zeroVal);
    
    //and give some info
    textSize(24);
    fill(252);
    text(data.description + ": Temp. Readings (celsius) " + data.rows[0].year + "-" + data.rows[41756].year, 5,30);
}

function loaded(){
   console.log('the data has loaded!');
    
}