//how do we get information loaded to from the server?
var nameInput;

function setup(){
    var cnv = createCanvas(400,400);
    cnv.parent('canvasDiv');
    background('255');
    nameInput = select('#nameInput');
    var button = select('#submit');
    button.mousePressed(submitData);
    
    //call the function to draw the data from the json file
    drawData();
}

function drawData(){
    //all will load the whole db json file.
    loadJSON('all',gotData);
}

function gotData(data){
    //what does the data look like.  (an array of drawings)
    //console.log(data);
    console.log(data.drawings);
    var drawingsUL = select('#drawings');
    for(var i=0; i<data.drawings.length; i++){
        var image = data.drawings[i].img;
        var text = data.drawings[i].name;
        var liEntry = createElement('li');
        liEntry.html(text);
        liEntry.parent(drawingsUL);
        var imgEntry = createImg(image);
        imgEntry.parent(liEntry);
    }
}

function mouseDragged() {
    stroke(0);
    strokeWeight(8);
	line(mouseX, mouseY, pmouseX, pmouseY);
}

//what happens when we hit submit button?
function submitData(){
    
    //run save frames again to save the new canvas with current pic, but with a different setting
    saveFrames('out', 'png', 1, 2, gotPostFrame);

    
    function gotPostFrame(data){
        console.log("image generated from canvas, sending");
        //use http post to post this to the server with our path
        var rawImage = data[0].imageData;
        //console.log(rawImage);
        //split this string to send to twitter
        var imgString = rawImage.split(',');
        //the base 64 string with no header will be at the second position of this array
        var imgDB = imgString[1];
        //get the text
        var nameText = nameInput.value();//should probably check this at some point to make sure no one inputs sth funky
        //format it as an object
        //let's make a key, too
        var sendData = {
            name: nameText,
            img: rawImage
        }

        //and post it to the path we set up in the server
        httpPost('/saveData', sendData, dataPosted, dataError);
        
    }
    
    function dataPosted(data){
        //this logs the reply we get back from the server.  So, only if tweet posted, run the command to draw these on the page
        console.log(data);//this should be our object with the new addition, back from the server
        clearThePage();//clear the P's and clear the Drawing on the Canvas
        drawData(); //draw the data again with the new addition

    }
    function dataError(err){
        console.log(err);
    }
}

function clearThePage(){
    //clear the canvas
    background(255);
    //remove with vanilla js because it's just easier and more reliable.
    var scoresUL = document.getElementById('drawings');
    //console.log(scoresUL);
    var listLength = scoresUL.children.length;
    //remove all of the child elements of the scores ul.
    for (i = 0; i < listLength; i++) {
    scoresUL.removeChild(scoresUL.children[0]);
  }
}
    
