//A simple express server written in node, serving up an example app that stores data to a local JSON file and lets the user input data and add to this file.
//navigate into this main folder in your command line and run "npm start" to start the server, and go to http://localhost:5000 to see the index.html file in "public"

//first, require express; a reference to a function that we'll hold in a variable
var express = require('express');
//lets get some things together
console.log('server starting....');
//we have a reference to express, so now create the app. Run the function.
var app = express();
//now listen to a port
// Set up the server
// process.env.PORT is related to deploying on heroku
var server = app.listen(process.env.PORT || 5000, listen);

// This call back just tells us that the server has started
function listen() {
  var host = server.address().address;
  var port = server.address().port;
  console.log('Example app listening at http://' + host + ':' + port);
}

//and host files on it.  Serve a static website, for example
//if we want to just serve some static files.
//this tells the app to serve the public folder at port 3000
app.use(express.static('public'));

//this is the standard format for writing get commands
app.get('/myPath', executeWhenPathIsFollowed);

//go to http://localhost:3000/myPath to see what happens
function executeWhenPathIsFollowed(request, response){
    response.send("a command executed!! And we got this back");
}

//instead of getting that data and responding with it, save some JSON
//need to use the fs module, the file system module built into node
var fs = require('fs');

//read the json file
var data = fs.readFileSync('scores.json');
//parse it
var scores = JSON.parse(data);
//console.log(scores);

//make a path to add someting to this data.
app.get('/add/:name/:score?', newEntry);


function newEntry(request,response){
    
    var data = request.params;//get the data
    var name = data.name;//get the name
    var score = Number(data.score);//get the score, and make sure it's a number
    var reply;//create a variable for the reply to be sent back
    if(!score){//if there isn't a score, if that value is null
       var reply = {
           msg: "Error: score is required"
       }
       response.send(reply);//send the error message in reply
    } else {
        //add the data to the object.  The name is the key and the score is the value
        scores[name] = score;
        //.stringify will make sure it's json
        var data = JSON.stringify(scores, null, 2);
        //write the new scores array to scores.json
        fs.writeFile('scores.json', data, finished);
        function finished(err){
            if(err){
                console.log(err);
            } else {
                var reply = {
                msg: "thanks for adding your score",
                newScores: scores
                }
            console.log('thanks for your addition, it worked.')
            }
            response.send(reply);
        }
        
    }
    
}

//a path to return all of the data
app.get('/all', sendAll);

function sendAll(request,response){
    response.send(scores);
}